VERSION 5.00
Begin VB.UserControl Control1 
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   3600
   ScaleWidth      =   4800
   Begin VB.Timer ctlTimer 
      Enabled         =   0   'False
      Interval        =   50
      Left            =   2040
      Top             =   1440
   End
End
Attribute VB_Name = "Control1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

' 2005, Ralf Nebelo

'Notwendige Verweise:
'- Microsoft Visual Basic for Applications Extensibility 5.3

Private Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As Any, ByVal lpWindowName As Any) As Long
Private Declare Function IsWindowVisible Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function ShowWindow Lib "user32" (ByVal hwnd As Long, ByVal nCmdShow As Long) As Long

Const APPNAME As String = "MakroLock 1.0"
'Das folgende Kennwort fr die Ver-/Entschlsselung unbedingt durch eigenes Kennwort ersetzen!!!
Const KENNWORT As String = "TopSecret"
Dim blnAutoMode As Boolean
Dim objAPP As Object
Dim objMakroMen As Object

'**************************************************************************
'ffentliche Routinen
'**************************************************************************

Public Function AnwendungAnmelden(objOfficeApp As Object) As Boolean
    Dim intDummy As Integer
    Dim blnOK As Boolean

    'Fehlerverfolung ausschalten
    On Error Resume Next

    'Verweis auf aktuelle Office-Anwendung bernehmen
    Set objAPP = objOfficeApp
    'Wenn Verweis gltig, dann...
    If Not objAPP Is Nothing Then
        '... probeweise auf Visual-Basic-Projekt zugreifen
        intDummy = objAPP.VBE.VBProjects.Count
        'Wenn dabei ein Fehler auftritt, dann...
        If Err <> 0 Then
            '... Fehler melden
            Call Ausgabe(objAPP.Name & " vertraut derzeit dem Zugriff auf das Visual-Basic-Projekt nicht." & vbCr & "Bitte ndern Sie die entsprechende Option unter Extras-Makro-Sicherheit", vbCritical)
            'Anmeldung gescheitert
            blnOK = False
        'Wenn Zugriff mglich, dann...
        Else
            'Nach Office-Anwendung unterscheiden
            Select Case LCase(objAPP.Name)
            'Falls Word oder PowerPoint...
            Case "microsoft word", "microsoft powerpoint"
                '... auf Untermen "Makro" im Men "Extras" verweisen
                Set objMakroMen = objAPP.CommandBars("Menu Bar").FindControl(10, 30017, , , True)
            'Falls Excel...
            Case "microsoft excel"
                '... auf Untermen "Makro" im Men "Extras" verweisen
                Set objMakroMen = objAPP.CommandBars("Worksheet Menu Bar").FindControl(10, 30017, , , True)
            End Select
        
            'Wenn Untermen nicht existiert, dann...
            If objMakroMen Is Nothing Then
                '... Fehler melden
                Call Ausgabe("Diese Version von " & objAPP.Name & " wird nicht untersttzt", vbCritical)
                'Anmeldung gescheitert
                blnOK = False
            'Wenn Untermen existiert, dann...
            Else
                '... Anmeldung gelungen
                blnOK = True
            End If
        End If
    End If
    
    'Wenn Anmeldung gescheitert, dann...
    If blnOK = False Then
        '... Objektvariable freigeben
        Set objAPP = Nothing
    End If
    
    'Anmeldeergebnis zurckgeben
    AnwendungAnmelden = blnOK
End Function

Public Sub MakrosStarten()
    Dim objVBProjekt As VBProject
    Dim objVBKomponente As VBComponent
    Dim intI As Integer
    Dim strZeile As String
    Dim strMakro As String
    Dim vntFeld As Variant
    Dim strVBProjekt As String
    Dim strVBKomponente As String
    Dim strVBMakro As String

    'Fehlerverfolung ausschalten
    On Error Resume Next
    
    'Wenn keine Office-Anwendung angemeldet, dann...
    If objAPP Is Nothing Then
        '... Fehlermeldung ausgeben
        Call Ausgabe("Keine Office-Anwendung angemeldet", vbCritical)
        'Prozedur verlassen
        Exit Sub
    End If
    
    'Timer zum permanenten Ausblenden des VBE aktivieren
    ctlTimer.Enabled = True
    
    'VB-Form frmMakroLock konfigurieren
    With frmMakroLock
        'Titeltext festlegen
        .Caption = APPNAME & " -  2005, Ralf Nebelo"
        'Namen der Office-Anwendung in Statuszeile anzeigen
        .stbStatus.SimpleText = objAPP.Name
        'Listenfeld lschen
        .lstListenfeld.Clear
    
        'Alle VBA-Projekte durchlaufen
        For Each objVBProjekt In objAPP.VBE.VBProjects
            'Wenn Projekt nicht geschtzt ist, dann...
            If objVBProjekt.Protection = vbext_pp_none Then
                '... alle Komponenten des jeweiligen VBA-Projekts durchlaufen
                For Each objVBKomponente In objVBProjekt.VBComponents
                    'Wenn Komponente die Signatur "'@CKV@" enthlt, dann...
                    If objVBKomponente.CodeModule.Lines(1, 1) = "'@CKV@" Then
                        '... alle Code-Zeilen durchlaufen
                        For intI = 2 To objVBKomponente.CodeModule.CountOfLines
                            'Einzelne Code-Zeile einlesen
                            strZeile = objVBKomponente.CodeModule.Lines(intI, 1)
                            strMakro = ""
                            'Wenn Zeile mit "'@Sub" beginnt, dann...
                            If Left(strZeile, 5) = "'@Sub" Then
                                '... Makronamen isolieren
                                strMakro = Mid(strZeile, 7, Len(strZeile) - 8)
                            'Wenn Zeile mit "'@Public Sub" beginnt, dann...
                            ElseIf Left(strZeile, 12) = "'@Public Sub" Then
                                '... Makronamen isolieren
                                strMakro = Mid(strZeile, 14, Len(strZeile) - 15)
                            End If
                            
                            'Wenn Makroname ermittelt, dann...
                            If strMakro > "" Then
                                '... vollstndigen Makropfad in Listenfeld eintragen
                                .lstListenfeld.AddItem objVBProjekt.Name & "." & objVBKomponente.Name & "." & strMakro
                            End If
                        Next
                    End If
                Next
            End If
        Next
        
        'Namen des zuletzt gestarteten Makros markieren
        .lstListenfeld.Text = GetSetting(APPNAME, "Einstellungen", "LetztesMakro", "")
        
        'VB-Form modal anzeigen
        .Show vbModal
        'Wenn Tag-Eigenschaft Text enthlt, dann...
        If .Tag > "" Then
            '... Makropfad in Bestandteile zerlegen
            vntFeld = Split(.Tag, ".")
            'Namen des VBA-Projekts isolieren
            strVBProjekt = vntFeld(0)
            'Namen der Komponente isolieren
            strVBKomponente = vntFeld(1)
            'Namen des Makros isolieren
            strVBMakro = vntFeld(2)
            
            'Beim Ver- und Entschlsseln keine MsgBox-Meldungen
            'anzeigen und kein Passwort abfragen
            blnAutoMode = True
            
            'Untermen "Makros" ausblenden
            objMakroMen.Visible = False
            
            'Komponente entschlsseln
            Call KomponenteEntschlsseln(strVBProjekt, strVBKomponente)
            
            'Bei Makroausfhrung nach Office-Anwendung unterscheiden
            Select Case LCase(objAPP.Name)
            'Falls Word oder Excel...
            Case "microsoft word", "microsoft excel"
                '... Makrounterbrechung mit [Strg]+[Pause] abschalten
                objAPP.EnableCancelKey = 0
                
                'Kompletten Makropfad beim Start angeben
                objAPP.Run strVBProjekt & "." & strVBKomponente & "." & strVBMakro
            
                'Makrounterbrechung mit [Strg]+[Pause] wieder einschalten
                objAPP.EnableCancelKey = 1
            'Falls PowerPoint...
            Case "microsoft powerpoint"
                '... kurzen Makropfad beim Start angeben
                objAPP.Run strVBKomponente & "." & strVBMakro
            End Select
            
            'Komponente wieder verschlsseln
            Call KomponenteVerschlsseln(strVBProjekt, strVBKomponente)
            
            'Untermen "Makros" einblenden
            objMakroMen.Visible = True
            
            'MsgBox-Meldungen wieder anzeigen
            blnAutoMode = False
            
            'Makropfad in Registry speichern
            SaveSetting APPNAME, "Einstellungen", "LetztesMakro", .Tag
        End If
    End With
    
    'VB-Form entladen
    Unload frmMakroLock
    
    'Timer zum Ausblenden des VBE abschalten
    ctlTimer.Enabled = False
End Sub

Public Sub KomponenteVerschlsseln(strVBProjekt As String, strVBKomponente As String)
    Dim objVBKomponente As VBComponent
    Dim intI As Integer
    Dim strZeile As String
    Dim blnIstMakro As Boolean
    
    'Fehlerverfolung ausschalten
    On Error Resume Next
    
    'Wenn keine Office-Anwendung angemeldet, dann...
    If objAPP Is Nothing Then
        '... Fehlermeldung ausgeben
        Call Ausgabe("Keine Office-Anwendung angemeldet", vbCritical)
        'Prozedur verlassen
        Exit Sub
    End If
    
    'Verweis auf Code-Komponente holen
    Set objVBKomponente = objAPP.VBE.VBProjects(strVBProjekt).VBComponents(strVBKomponente)
    'Wenn Komponente nicht existiert, dann...
    If objVBKomponente Is Nothing Then
        '... Fehlermeldung ausgeben
        Call Ausgabe("Code-Komponente " & strVBProjekt & "." & strVBKomponente & " nicht gefunden", vbExclamation)
        'Prozedur verlassen
        Exit Sub
    End If
    
    'Wenn Komponente bereits als verschlsselt gekennzeichnet ist, dann...
    If objVBKomponente.CodeModule.Lines(1, 1) = "'@CKV@" Then
        '... Fehlermeldung ausgeben
        Call Ausgabe("Code-Komponente " & strVBProjekt & "." & strVBKomponente & " ist bereits verschlsselt", vbExclamation)
    'Ansonsten...
    Else
        '... Alle Code-Zeilen durchlaufen
        For intI = 1 To objVBKomponente.CodeModule.CountOfLines
            'Aktuelle Code-Zeile einlesen
            strZeile = objVBKomponente.CodeModule.Lines(intI, 1)
            'Wenn Zeile Header einer Prozedur ist, dann...
            If (InStr(Trim(strZeile), "Sub ") = 1 Or InStr(Trim(strZeile), "Public Sub ") = 1) Then
                '... wenn Prozedur ein Makro ist, dann...
                If InStr(strZeile, "()") > 0 Then
                    '... nur "'@" davorsetzen, nicht verschlsseln
                    objVBKomponente.CodeModule.ReplaceLine intI, "'@" & strZeile
                    'Status merken
                    blnIstMakro = True
                'Wenn Prozedur kein Makro ist, dann...
                Else
                    '... Zeile verschlsseln
                    objVBKomponente.CodeModule.ReplaceLine intI, "'" & Chiffrieren(strZeile, KENNWORT, True)
                    'Status merken
                    blnIstMakro = False
                End If
            'Wenn Zeile "End Sub" lautet und zu Makro gehrt, dann...
            ElseIf Trim(strZeile) = "End Sub" And blnIstMakro = True Then
                '... nur "'@" davorsetzen, nicht verschlsseln
                objVBKomponente.CodeModule.ReplaceLine intI, "'@" & strZeile
                'Status zurcksetzen
                blnIstMakro = False
            'Jede andere Code-Zeile...
            Else
                '... verschlsseln
                objVBKomponente.CodeModule.ReplaceLine intI, "'" & Chiffrieren(strZeile, KENNWORT, True)
            End If
        Next
        'Komponente durch Einfgen von "'@CKV@" als verschlsselt kennzeichnen
        objVBKomponente.CodeModule.InsertLines 1, "'@CKV@"
        
        'Erfolgsmeldung ausgeben
        Call Ausgabe("Code-Komponente " & strVBProjekt & "." & strVBKomponente & " erfolgreich verschlsselt", vbInformation)
    End If
End Sub

Public Sub KomponenteEntschlsseln(strVBProjekt As String, strVBKomponente As String)
    Dim objVBKomponente As VBComponent
    Dim strAbfrage As String
    Dim intI As Integer
    Dim strZeile As String
    
    'Fehlerverfolung ausschalten
    On Error Resume Next
    
    'Wenn keine Office-Anwendung angemeldet, dann...
    If objAPP Is Nothing Then
        '... Fehlermeldung ausgeben
        Call Ausgabe("Keine Office-Anwendung angemeldet", vbCritical)
        'Prozedur verlassen
        Exit Sub
    End If
    
    'Verweis auf Code-Komponente holen
    Set objVBKomponente = objAPP.VBE.VBProjects(strVBProjekt).VBComponents(strVBKomponente)
    'Wenn Komponente nicht existiert, dann...
    If objVBKomponente Is Nothing Then
        '... Fehlermeldung ausgeben
        Call Ausgabe("Code-Komponente " & strVBProjekt & "." & strVBKomponente & " nicht gefunden", vbExclamation)
        'Prozedur verlassen
        Exit Sub
    End If
    
    'Wenn Komponente nicht verschlsselt ist, dann...
    If objVBKomponente.CodeModule.Lines(1, 1) <> "'@CKV@" Then
        '... Fehlermeldung ausgeben
        Call Ausgabe("Code-Komponente " & strVBProjekt & "." & strVBKomponente & " ist bereits entschlsselt", vbExclamation)
    'Ansonsten...
    Else
        '... wenn Prozedur vom User aufgerufen, dann...
        If blnAutoMode = False Then
            '... Kennwort abfragen
            strAbfrage = InputBox("Kennwort:", APPNAME)
            'Wenn Kennwort nicht korrekt ist, dann...
            If strAbfrage <> KENNWORT Then
                '... Meldung ausgeben
                MsgBox "Das Kennwort ist falsch.", vbExclamation, APPNAME
                'Prozedur verlassen
                Exit Sub
            End If
        End If
    
        'Alle Code-Zeilen ab der zweiten durchlaufen
        For intI = 2 To objVBKomponente.CodeModule.CountOfLines
            'Aktuelle Code-Zeile einlesen
            strZeile = objVBKomponente.CodeModule.Lines(intI, 1)
            'Wenn Zeile mit Hochkomma beginnt...
            If Left(strZeile, 1) = "'" Then
                '... wenn Zeile Header eines Makros ist, dann...
                If Left(strZeile, 5) = "'@Sub" Or Left(strZeile, 12) = "'@Public Sub" Then
                    '... ersten beiden Zeichen entfernen
                    objVBKomponente.CodeModule.ReplaceLine intI, Right(strZeile, Len(strZeile) - 2)
                'Wenn Zeile "'@End Sub" lautet, dann...
                ElseIf Left(strZeile, 9) = "'@End Sub" Then
                    '... ersten beiden Zeichen entfernen
                    objVBKomponente.CodeModule.ReplaceLine intI, Right(strZeile, Len(strZeile) - 2)
                'Wenn Zeile nur aus Hochkomma besteht, dann...
                ElseIf Len(strZeile) = 1 Then
                    '... Leerzeile einfgen
                    objVBKomponente.CodeModule.ReplaceLine intI, ""
                'Jede andere Zeile...
                Else
                    '... entschlsseln
                    objVBKomponente.CodeModule.ReplaceLine intI, Chiffrieren(Right(strZeile, Len(strZeile) - 1), KENNWORT, False)
                End If
            End If
        Next
        'Verschlsselungs-Signatur "'@CKV@" entfernen
        objVBKomponente.CodeModule.DeleteLines 1, 1
        
        'Erfolgsmeldung ausgeben
        Call Ausgabe("Code-Komponente " & strVBProjekt & "." & strVBKomponente & " erfolgreich entschlsselt", vbInformation)
    End If
End Sub

'**************************************************************************
'Ereignisroutinen des Controls
'**************************************************************************

Private Sub ctlTimer_Timer()
    Dim lngFensterHandle As Long
    Dim lngRetVal As Long
    
    'Fenster-Handle des Visual-Basic-Editors (VBE) abfragen
    lngFensterHandle = FindWindow("wndclass_desked_gsk", 0&)
    'Wenn sichtbar, dann...
    If CBool(IsWindowVisible(lngFensterHandle)) = True Then
        '... ausblenden
        lngRetVal = ShowWindow(lngFensterHandle, 0)
    End If

'    'Fenster-Handle des Windows Task-Managers abfragen
'    lngFensterHandle = FindWindow(0&, "Windows Task-Manager")
'    'Wenn sichtbar, dann...
'    If CBool(IsWindowVisible(lngFensterHandle)) = True Then
'        '... ausblenden
'        lngRetVal = ShowWindow(lngFensterHandle, 0)
'    End If
End Sub

Private Sub UserControl_Terminate()
    'Verweis auf laufende Instanz der Office-Anwendung lschen
    Set objAPP = Nothing
End Sub

'**************************************************************************
'Hilfsroutinen
'**************************************************************************

Private Function Chiffrieren(strText As String, strKennwort As String, Optional blnVerschlsseln = True) As String
    Dim intTxtCharPos As Integer
    Dim intTxtCharCode As Integer
    Dim intPwdCharPos As Integer
    Dim intPwdCharCode As Integer
    Dim intNewCode As Integer
    Dim strTmp As String
    
    'Alle Zeichen des Textes durchlaufen
    For intTxtCharPos = 1 To Len(strText)
        'ASCII-Code des aktuellen Textzeichens holen
        intTxtCharCode = Asc(Mid(strText, intTxtCharPos, 1))
         
        'Wenn Zeichen ein Leerzeichen ist, dann...
        If intTxtCharCode = 32 Then
            '... durch Leerzeichen ersetzen
            intNewCode = 32
        'Bei jedem anderen Zeichen...
        Else
            '... Position im Kennwort um 1 erhhen
            intPwdCharPos = intPwdCharPos + 1
            'Wenn Position grer als Kennwortlnge, dann...
            If intPwdCharPos > Len(strKennwort) Then
                '... Position auf 1 zurcksetzen
                intPwdCharPos = 1
            End If
            'ASCII-Code des aktuellen Kennwortzeichens holen
            intPwdCharCode = Asc(Mid(strKennwort, intPwdCharPos, 1))
            
            'Wenn verschlsselt werden soll, dann...
            If blnVerschlsseln = True Then
                '... Codes von Text- und Kennwortzeichen addieren
                'und daraus Code des Ersatzzeichens bilden
                intNewCode = intTxtCharCode + intPwdCharCode
                'Wenn Ersatzzeichen-Code grer als 255, dann...
                If intNewCode > 255 Then
                    '... 224 abziehen
                    intNewCode = intNewCode - 224
                End If
            'Wenn entschlsselt werden soll, dann...
            Else
                '... Kennwortzeichen-Code von Textzeichen-Code abziehen
                'und daraus Code des Ersatzzeichens bilden
                intNewCode = intTxtCharCode - intPwdCharCode
                'Wenn Ersatzzeichen-Code kleiner als 32, dann...
                If intNewCode < 32 Then
                    '... 224 addieren
                    intNewCode = intNewCode + 224
                End If
            End If
        End If
        
        'Ersatzzeichen an strTmp anhngen
        strTmp = strTmp & Chr(intNewCode)
    Next
    
    'strTmp zurckgeben
    Chiffrieren = strTmp
End Function

Private Sub Ausgabe(strText As String, intMsgTyp As Integer)
    'Wenn kein Automatikmodus aktiv, dann...
    If blnAutoMode = False Then
        '... Nachricht per MsgBox-Dialog ausgeben
        MsgBox strText & ".", intMsgTyp, APPNAME
    End If
End Sub

